// UMatch.cp
// UMatch.h
// ----------------------------------------------------------------------------------
// Matches regular expressions.
//
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//  Match the pattern PATTERN against the string TEXT;
//  return TRUE if it matches, FALSE otherwise.
//
//  A match means the entire string TEXT is used up in matching.
//
//  In the pattern string:
//       `*' matches any sequence of characters
//       `?' matches any character
//       [SET] matches any character in the specified set,
//       [!SET] or [^SET] matches any character not in the specified set.
//
//  Note: the standard regex character '+' (one or more) should by
//        simulated by using "?*" which is equivelant here.
//
//  A set is composed of characters or ranges; a range looks like
//  character hyphen character (as in 0-9 or A-Z).  [0-9a-zA-Z_] is the
//  minimul set of characters allowed in the [..] pattern construct.
//  Other characters are allowed (ie. 8 bit characters) if your system
//  will support them.
//
//  To suppress the special syntactic significance of any of `[]*?!^-\',
//  and match the character exactly, precede it with a `\'.
//
// ----------------------------------------------------------------------------------
// History:
// 		J. Kercheval		01/05/91
//			Original in public domain
//		Clark Goble			08/14/94
//			Checked it over and made a few modifications as part of the
//			C++ conversion.
// ----------------------------------------------------------------------------------


#ifndef BOOLEAN
# define BOOLEAN short
#endif 

#ifndef TRUE
# define TRUE (1)
#endif

#ifndef FALSE
# define FALSE (0)
#endif

class UMatch {
public:
	static BOOLEAN match (char *pattern, char *text);
	static BOOLEAN is_pattern (char *pattern);
private:
	static BOOLEAN regex_match_after_star (char *pattern, char *text);
	static BOOLEAN regex_match ( register char *p, register char *t );
};



